/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public abstract class Upgrade
extends CapabilityProvider<Upgrade>
implements INBTSerializable<CompoundTag> {
    private final UpgradeType type;
    protected final PlaneEntity planeEntity;
    public boolean updateClient = false;
    public boolean removed = false;

    public PlaneEntity getPlaneEntity() {
        return this.planeEntity;
    }

    public Upgrade(UpgradeType type, PlaneEntity planeEntity) {
        super(Upgrade.class);
        this.type = type;
        this.planeEntity = planeEntity;
    }

    protected void updateClient() {
        this.updateClient = true;
    }

    public void remove() {
        this.removed = true;
        this.invalidateCaps();
    }

    public final UpgradeType getType() {
        return this.type;
    }

    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
    }

    public void tick() {
    }

    public abstract void render(PoseStack var1, MultiBufferSource var2, int var3, float var4);

    public CompoundTag serializeNBT() {
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
    }

    public void onApply(ItemStack itemStack, Player playerEntity) {
    }

    public abstract void writePacket(FriendlyByteBuf var1);

    public abstract void readPacket(FriendlyByteBuf var1);

    public abstract void onRemoved();

    public boolean canBeDroppedAsPayload() {
        return false;
    }

    public void dropAsPayload() {
    }
}

